<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data;

/**
 * Interface LogInterface
 */
interface LogInterface
{
    public const LOG_ID = 'log_id';
    public const MESSAGE = 'message';
    public const LEVEL = 'level';
    public const CREATED_AT = 'created_at';

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * Get message
     *
     * @return string|null
     */
    public function getMessage();

    /**
     * Get level
     *
     * @return string|null
     */
    public function getLevel();

    /**
     * Get created at
     *
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * Set ID
     *
     * @param int $logId
     *
     * @return \Fastmag\Sync\Api\Data\LogInterface
     */
    public function setId($logId);

    /**
     * Set message
     *
     * @param string $message
     *
     * @return \Fastmag\Sync\Api\Data\LogInterface
     */
    public function setMessage($message);

    /**
     * Set level
     *
     * @param string $level
     *
     * @return \Fastmag\Sync\Api\Data\LogInterface
     */
    public function setLevel($level);
}
