<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data;

/**
 * Interface OrderInterface
 */
interface OrderInterface
{
    public const ENTITY_ID = 'entity_id';
    public const ORDER_ID = 'order_id';
    public const TRANSACTION_ID = 'transaction_id';
    public const TRANSACTION_ID_2 = 'transaction_id_2';
    public const TYPE = 'type';
    public const STATE = 'state';
    public const EDI_CSV = 'edi_csv';
    public const EDI_SERIALIZED = 'edi_serialized';
    public const RESULT_LOG = 'result_log';
    public const REQUEST_AT = 'request_at';
    public const RESULT_AT = 'result_at';
    public const ORIGIN_SHOP = 'origin_shop';
    public const TARGET_SHOP = 'target_shop';

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * Get order ID
     *
     * @return int|null
     */
    public function getOrderId();

    /**
     * Get transaction ID
     *
     * @return int|null
     */
    public function getTransactionId();

    /**
     * Get transaction ID 2
     *
     * @return int|null
     */
    public function getTransactionId2();

    /**
     * Get type
     *
     * @return string|null
     */
    public function getType();

    /**
     * Get state
     *
     * @return string|null
     */
    public function getState();

    /**
     * Get EDI CSV
     *
     * @return string|null
     */
    public function getEdiCsv();

    /**
     * Get EDI serialized
     *
     * @return string|null
     */
    public function getEdiSerialized();

    /**
     * Get result log
     *
     * @return string|null
     */
    public function getResultLog();

    /**
     * Get request at
     *
     * @return string|null
     */
    public function getRequestAt();

    /**
     * Get result at
     *
     * @return string|null
     */
    public function getResultAt();

    /**
     * Get origin shop
     *
     * @return string|null
     */
    public function getOriginShop();

    /**
     * Get target shop
     *
     * @return string|null
     */
    public function getTargetShop();

    /**
     * Set ID
     *
     * @param int $orderId
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setId($orderId);

    /**
     * Set order ID
     *
     * @param int $orderId
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setOrderId($orderId);

    /**
     * Set transaction ID
     *
     * @param int $transactionId
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setTransactionId($transactionId);

    /**
     * Set transaction ID 2
     *
     * @param int $transactionId2
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setTransactionId2($transactionId2);

    /**
     * Set type
     *
     * @param string $type
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setType($type);

    /**
     * Set state
     *
     * @param string $state
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setState($state);

    /**
     * Set EDI CSV
     *
     * @param string $ediCsv
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setEdiCsv($ediCsv);

    /**
     * Set EDI serialized
     *
     * @param string $ediSerialized
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setEdiSerialized($ediSerialized);

    /**
     * Set result log
     *
     * @param string $resultLog
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setResultLog($resultLog);

    /**
     * Set request at
     *
     * @param string $requestAt
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setRequestAt($requestAt);

    /**
     * Set result at
     *
     * @param string $resultAt
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setResultAt($resultAt);

    /**
     * Set origin shop
     *
     * @param string $originShop
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setOriginShop($originShop);

    /**
     * Set target shop
     *
     * @param string $targetShop
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     */
    public function setTargetShop($targetShop);
}
