<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-05-04
 ******************************************************************************/

namespace Fastmag\Sync\Api;

use Fastmag\Sync\Api\Data\OrderInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Interface OrderRepositoryInterface
 */
interface OrderRepositoryInterface
{
    /**
     * Save order.
     *
     * @param \Fastmag\Sync\Api\Data\OrderInterface $order
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(OrderInterface $order);

    /**
     * Retrieve order.
     *
     * @param int $entityId
     *
     * @return \Fastmag\Sync\Api\Data\OrderInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($entityId);

    /**
     * Retrieve orders matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\OrderSearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Delete order.
     *
     * @param \Fastmag\Sync\Api\Data\OrderInterface $order
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(OrderInterface $order);

    /**
     * Delete order by ID.
     *
     * @param int $entityId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($entityId);
}
