<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-07-17
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Preconfig;

use Exception;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\System\Preconfig\File;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Config\Storage\WriterInterface;

/**
 * Class Delete
 *
 * Preconfig folder delete action
 */
class Delete extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::preconfig';

    /** @var Logger $logger */
    protected $logger;

    /** @var File $file */
    protected $file;

    /** @var WriterInterface $writer */
    protected $writer;

    /**
     * Delete constructor
     *
     * @param Context         $context
     * @param Logger          $logger
     * @param File            $file
     * @param WriterInterface $writer
     */
    public function __construct(
        Context $context,
        Logger $logger,
        File $file,
        WriterInterface $writer
    ) {
        parent::__construct($context);

        $this->logger = $logger;
        $this->file = $file;
        $this->writer = $writer;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        try {
            $this->file->delete();

            $this->writer->save('fastmag_sync_connect/state/preconfig_todo', 0);
        } catch (Exception $e) {
            $message =
                __('Unable to delete the directory. Please contact Home-made.io ASAP.') . ' Error: ' . $e->getMessage();
            $this->logger->critical($message);
            $this->messageManager->addErrorMessage($message);
        }

        /* @todo > 1.0.0 : redirect to current page instead */
        $resultRedirect = $this->resultRedirectFactory->create();
        $resultRedirect->setPath('adminhtml');

        return $resultRedirect;
    }
}
