<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-05-14
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Rule\Ordertransaction;

use Exception;
use Fastmag\Sync\Api\Rule\OrdertransactionRepositoryInterface;
use Fastmag\Sync\Controller\Adminhtml\Rule\Ordertransaction as ControllerAbstract;
use Fastmag\Sync\Model\Rule\Ordertransaction;
use Fastmag\Sync\Model\Rule\OrdertransactionFactory;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Redirect;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\Exception\LocalizedException;

/**
 * Class Save
 *
 * Ordertransaction save action
 *
 * @todo change architecture to avoid code duplication
 */
class Save extends ControllerAbstract implements HttpPostActionInterface
{
    /** @var OrdertransactionFactory $ruleFactory */
    protected $ruleFactory;

    /**
     * Save constructor
     *
     * @param Context                             $context
     * @param DataPersistorInterface              $dataPersistor
     * @param OrdertransactionRepositoryInterface $ruleRepository
     * @param OrdertransactionFactory             $ruleFactory
     */
    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor,
        OrdertransactionRepositoryInterface $ruleRepository,
        OrdertransactionFactory $ruleFactory
    ) {
        parent::__construct($context, $dataPersistor, $ruleRepository);

        $this->ruleFactory = $ruleFactory;
    }

    /**
     * Save action
     *
     * @return Redirect
     */
    public function execute()
    {
        /** @var Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        $data = $this->getRequest()->getPostValue();

        if ($data) {
            if (empty($data['rule_id'])) {
                $data['rule_id'] = null;
            }

            $rule = $this->ruleFactory->create();

            $ruleId = $this->getRequest()->getParam('rule_id');
            if ($ruleId) {
                try {
                    $rule = $this->ruleRepository->getById($ruleId);
                } catch (LocalizedException $e) {
                    $this->messageManager->addErrorMessage(__('This rule no longer exists.'));
                    
                    return $resultRedirect->setPath('*/*/');
                }
            }

            $rule->setData($data);

            try {
                $this->ruleRepository->save($rule);
                $this->messageManager->addSuccessMessage(__('The rule has been saved.'));
                $this->dataPersistor->clear('ordertransaction_rule');

                return $this->processReturn($rule, $data, $resultRedirect);
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            } catch (Exception $e) {
                $this->messageManager->addExceptionMessage($e, __('Something went wrong while saving the rule.'));
            }

            $this->dataPersistor->set('ordertransaction_rule', $data);

            return $resultRedirect->setPath('*/*/edit', ['id' => $ruleId]);
        }

        return $resultRedirect->setPath('*/*/');
    }

    /**
     * Process and set the return
     *
     * @param Ordertransaction $rule
     * @param array            $data
     * @param Redirect         $resultRedirect
     *
     * @return Redirect
     *
     * @throws LocalizedException
     */
    private function processReturn($rule, $data, $resultRedirect)
    {
        $redirect = $data['back'] ?? 'close';

        if ($redirect === 'continue') {
            $resultRedirect->setPath('*/*/edit', ['id' => $rule->getId()]);
        } elseif ($redirect === 'close') {
            $resultRedirect->setPath('*/*/');
        } elseif ($redirect === 'duplicate') {
            $duplicateRule = $this->ruleFactory->create(['data' => $data]);
            $duplicateRule->setId(null)
                ->setData(Ordertransaction::CREATED_AT, null)
                ->setData(Ordertransaction::UPDATED_AT, null);
            $this->ruleRepository->save($duplicateRule);

            $ruleId = $duplicateRule->getId();

            $this->messageManager->addSuccessMessage(__('You duplicated the rule.'));
            $this->dataPersistor->set('ordertransaction_rule', $data);
            $resultRedirect->setPath('*/*/edit', ['id' => $ruleId]);
        }

        return $resultRedirect;
    }
}
