<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-06-22
 ******************************************************************************/

namespace Fastmag\Sync\FastmagSetup;

/**
 * Class Uninstaller
 *
 * Class handling job queue and triggers deletion on Fastmag
 */
class Uninstaller
{
    /**
     * Get uninstallation queries
     *
     * @return array
     */
    public function getUninstallQueries()
    {
        $sql = ['triggers' => [], 'tables' => []];

        $sql['tables'][] = 'DROP TABLE IF EXISTS fmsync_job_queue;';

        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produitsfiches_update;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produitslangues_update;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produits_update;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produitstarifs_insert;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produitstarifs_update;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produitstarifs_delete;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promo_insert;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promo_update;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promo_delete;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promotc_insert;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promotc_update;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produits_promotc_delete;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produits_prixqte_insert;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produits_prixqte_update;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produits_prixqte_delete;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produits_image_stock_insert;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produits_image_stock_update;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_vente_update;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produits_vente_insert;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_produits_vente_update;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_client_insert;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_client_update;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_client_addr_liv_insert;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_client_addr_liv_update;';
        $sql['triggers'][] = 'DROP TRIGGER IF EXISTS trigger_fmsync_client_addr_liv_delete;';

        return $sql;
    }
}
