<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-22
 ******************************************************************************/

namespace Fastmag\Sync\Model;

use Magento\Framework\App\Config\ScopeConfigInterface;

/**
 * Class Config
 *
 * Config getter for all Fastmag Sync classes
 * Substitute ScopeConfig class and contains all the config fields added by the plugin
 */
class Config
{
    /** @var string */
    public const XML_PATH_CONNECT_EDI_SHOP = 'fastmag_sync_connect/edi/shop';

    /** @var string */
    public const XML_PATH_CONNECT_PROXY_NATIVE_SQL_CONNECTION = 'fastmag_sync_connect/proxy/native_sql_connection';

    /** @var string */
    public const XML_PATH_JOBQUEUE_SYNC_ENABLED = 'fastmag_sync_jobqueue/sync/enable';

    /** @var string */
    public const XML_PATH_JOBQUEUE_SYNC_WEBSITE_ID = 'fastmag_sync_jobqueue/sync/website_id';

    /** @var string */
    public const XML_PATH_JOBQUEUE_ADVANCED_REACTIVITY = 'fastmag_sync_jobqueue/advanced/reactivity';

    /** @var string */
    public const XML_PATH_JOBQUEUE_ADVANCED_JOBS_LIMIT = 'fastmag_sync_jobqueue/advanced/jobs_limit';

    /** @var string */
    public const XML_PATH_JOBQUEUE_ADVANCED_HYDRATION_SIZE = 'fastmag_sync_jobqueue/advanced/hydration_size';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_ENABLE = 'fastmag_sync_products/import/enable';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_ONLY_INVENTORY = 'fastmag_sync_products/import/only_inventory';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_ACTIVE_VISIBLEWEB = 'fastmag_sync_products/import/only_active_visibleweb';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_ONLY_STORESELLER = 'fastmag_sync_products/import/only_defined_storeseller';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_PARENT_PER_COLOR = 'fastmag_sync_products/import/parent_per_color';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_GENERIC_PRODUCTS = 'fastmag_sync_products/import/keep_generic_products';

    /** @var string */
    public const XML_PATH_PRODUCT_PRICE_MANAGE_TIER_PRICES = 'fastmag_sync_products/price/manage_tiers_price';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_FAMILY = 'fastmag_sync_products/other_attributes/sync_family';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_SUBFAMILY
        = 'fastmag_sync_products/other_attributes/sync_subfamily';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_SECTION = 'fastmag_sync_products/other_attributes/sync_section';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_SEASON = 'fastmag_sync_products/other_attributes/sync_season';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_MODEL = 'fastmag_sync_products/other_attributes/sync_model';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_MATERIAL
        = 'fastmag_sync_products/other_attributes/sync_material';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_THEME = 'fastmag_sync_products/other_attributes/sync_theme';

    /** @var string */
    public const XML_PATH_CUSTOMER_IMPORT_ENABLE = 'fastmag_sync_customers/import/enable';

    /** @var string */
    public const XML_PATH_CUSTOMER_IMPORT_INACTIVE_CUSTOMERS = 'fastmag_sync_customers/import/inactive_customers';

    /** @var string */
    public const XML_PATH_CUSTOMER_IMPORT_ACCOUNT_EMAIL = 'fastmag_sync_customers/import/account_email';

    /** @var string */
    public const XML_PATH_CUSTOMER_IMPORT_SHOP_PURCHASES = 'fastmag_sync_customers/import/shop_purchases';

    /** @var ScopeConfigInterface $scopeConfig */
    protected $scopeConfig;

    /** @var array $configCache */
    protected $cache = [];

    /**
     * Config constructor.
     *
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * Retrieve config value by path and scope.
     *
     * @see ScopeConfigInterface::getValue
     *
     * @param string      $path
     * @param string      $scopeType
     * @param null|string $scopeCode
     *
     * @return mixed
     */
    public function getValue($path, $scopeType = ScopeConfigInterface::SCOPE_TYPE_DEFAULT, $scopeCode = null)
    {
        $key = trim($path . '-' . $scopeType . '-' . $scopeCode, '-');

        if (!array_key_exists($key, $this->cache)) {
            $this->cache[$key] = $this->scopeConfig->getValue($path, $scopeType, $scopeCode);
        }

        return $this->cache[$key];
    }

    /**
     * Retrieve config flag by path and scope
     *
     * @see ScopeConfigInterface::isSetFlag
     *
     * @param string      $path
     * @param string      $scopeType
     * @param null|string $scopeCode
     *
     * @return bool
     */
    public function isSetFlag($path, $scopeType = ScopeConfigInterface::SCOPE_TYPE_DEFAULT, $scopeCode = null)
    {
        return (bool)$this->getValue($path, $scopeType, $scopeCode);
    }
}
