<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Provider;

use Fastmag\Sync\Model\Config\Provider;
use Magento\Store\Model\ScopeInterface;

/**
 * Class DirectSql
 *
 * Class giving access for direct SQL connection
 */
class DirectSql extends Provider
{
    /** @var string */
    public const XML_CONFIG_PREFIX = 'fastmag_sync_connect/proxy';

    /** @var string */
    public const XML_CONFIG_HOST = 'host';

    /** @var string */
    public const XML_CONFIG_PORT = 'port';

    /** @var string */
    public const XML_CONFIG_USER = 'user';

    /** @var string */
    public const XML_CONFIG_PASSWORD = 'password';

    /**
     * An alias for scope config with default scope type SCOPE_STORE
     *
     * @param string $key
     * @param string $scopeType
     *
     * @return string|null
     */
    public function getValue($key, $scopeType = ScopeInterface::SCOPE_STORE)
    {
        return parent::getValue(self::XML_CONFIG_PREFIX . '/' . $key, $scopeType);
    }

    /**
     * Get host
     *
     * @param $scopeType
     *
     * @return string|null
     */
    public function getHost($scopeType = ScopeInterface::SCOPE_STORE)
    {
        return $this->getValue(self::XML_CONFIG_HOST, $scopeType);
    }

    /**
     * Get port
     *
     * @param $scopeType
     *
     * @return string|null
     */
    public function getPort($scopeType = ScopeInterface::SCOPE_STORE)
    {
        return $this->getValue(self::XML_CONFIG_PORT, $scopeType);
    }

    /**
     * Get user
     *
     * @param $scopeType
     *
     * @return string|null
     */
    public function getUser($scopeType = ScopeInterface::SCOPE_STORE)
    {
        return $this->getValue(self::XML_CONFIG_USER, $scopeType);
    }

    /**
     * Get password
     *
     * @param $scopeType
     *
     * @return string|null
     */
    public function getPassword($scopeType = ScopeInterface::SCOPE_STORE)
    {
        return $this->getValue(self::XML_CONFIG_PASSWORD, $scopeType);
    }
}
