<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-17
 ******************************************************************************/

namespace Fastmag\Sync\Model\Jobqueue;

use Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface;
use Fastmag\Sync\Model\Jobqueue;
use Fastmag\Sync\Model\ResourceModel\Customer as ResourceModel;

/**
 * Class ToFastmag
 *
 * Model class for Magento to Fastmag synchronization jobs
 */
class ToFastmag extends Jobqueue implements ToFastmagInterface
{
    /** @var string */
    public const CACHE_TAG = 'fastmag_sync_jobqueue_tofastmag';

    /** @var string $_cacheTag */
    protected $_cacheTag = self::CACHE_TAG;

    /**
     * ToFastmag constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->getData(self::JOB_ID);
    }

    /**
     * @inheritDoc
     */
    public function getContentId()
    {
        return $this->getData(self::CONTENT_ID);
    }

    /**
     * @inheritDoc
     */
    public function getJobCode()
    {
        return $this->getData(self::JOB_CODE);
    }

    /**
     * @inheritDoc
     */
    public function getStatus()
    {
        return $this->getData(self::STATUS);
    }

    /**
     * @inheritDoc
     */
    public function getRetryCount()
    {
        return $this->getData(self::RETRY_COUNT);
    }

    /**
     * @inheritDoc
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getProcessedAt()
    {
        return $this->getData(self::PROCESSED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getHydratedData()
    {
        return $this->getData(self::HYDRATED_DATA);
    }

    /**
     * @inheritDoc
     */
    public function getMessage()
    {
        return $this->getData(self::MESSAGE);
    }

    /**
     * @inheritDoc
     */
    public function getTrace()
    {
        return $this->getData(self::TRACE);
    }

    /**
     * @inheritDoc
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * @inheritDoc
     */
    public function setId($jobId)
    {
        return $this->setData(self::JOB_ID, $jobId);
    }

    /**
     * @inheritDoc
     */
    public function setContentId($contentId)
    {
        return $this->setData(self::CONTENT_ID, $contentId);
    }

    /**
     * @inheritDoc
     */
    public function setJobCode($jobCode)
    {
        return $this->setData(self::JOB_CODE, $jobCode);
    }

    /**
     * @inheritDoc
     */
    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * @inheritDoc
     */
    public function setRetryCount($retryCount)
    {
        return $this->setData(self::RETRY_COUNT, $retryCount);
    }

    /**
     * @inheritDoc
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * @inheritDoc
     */
    public function setProcessedAt($processedAt)
    {
        return $this->setData(self::PROCESSED_AT, $processedAt);
    }

    /**
     * @inheritDoc
     */
    public function setHydratedData($hydratedData)
    {
        return $this->setData(self::HYDRATED_DATA, $hydratedData);
    }

    /**
     * @inheritDoc
     */
    public function setMessage($message)
    {
        return $this->setData(self::MESSAGE, $message);
    }

    /**
     * @inheritDoc
     */
    public function setTrace($trace)
    {
        return $this->setData(self::TRACE, $trace);
    }

    /**
     * Reset job
     *
     * @return $this
     */
    public function reset()
    {
        return $this->setStatus(1)->setProcessedAt(null)->incrementRetryCount();
    }

    /**
     * Increment retry count
     *
     * @param int $increment
     *
     * @return $this
     */
    public function incrementRetryCount($increment = 1)
    {
        return $this->setRetryCount($this->getRetryCount() + $increment);
    }
}
