<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Entity\ToMagento\Helper\Attribute;

use Fastmag\Sync\Model\Process\Entity\ToMagento\Helper\AttributeInterface;

/**
 * Class Gender
 *
 * Helper class to help format gender for Magento
 */
class Gender implements AttributeInterface
{
    /** @var int $defaultValue */
    protected static $defaultValue = 3;

    /** @var array $values */
    protected static $values = [
        'MADAME' => 2,
        'MME' => 2,
        'MONSIEUR' => 1,
        'M' => 1,
        'MR' => 1,
    ];

    /**
     * @inheritDoc
     *
     * @param string $fastmagValue
     *
     * @return int
     */
    public static function getMagentoValue($fastmagValue)
    {
        $result = self::getDefaultValue();

        if (array_key_exists($fastmagValue, self::$values)) {
            $result = self::$values[$fastmagValue];
        }

        return $result;
    }

    /**
     * @inheritDoc
     *
     * @return int
     */
    public static function getDefaultValue()
    {
        return self::$defaultValue;
    }
}
