<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Entity\ToMagento\Helper\Attribute;

use Fastmag\Sync\Model\Process\Entity\ToMagento\Helper\AttributeInterface;

/**
 * Class Prefix
 *
 * Helper class to help format prefix for Magento
 */
class Prefix implements AttributeInterface
{
    /** @var array $values */
    protected static $values = [
        'MADAME' => 'MME',
        'MME' => 'MME',
        'MONSIEUR' => 'M',
        'M' => 'M',
        'MR' => 'M',
    ];

    /**
     * @inheritDoc
     *
     * @param string $fastmagValue
     *
     * @return int|null
     */
    public static function getMagentoValue($fastmagValue)
    {
        $result = self::getDefaultValue();

        if (array_key_exists($fastmagValue, self::$values)) {
            $result = self::$values[$fastmagValue];
        }

        return $result;
    }

    /**
     * @inheritDoc
     *
     * @return null
     */
    public static function getDefaultValue()
    {
        return null;
    }
}
