<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-17
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Worker;

use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Process\Worker;
use Fastmag\Sync\Model\ResourceModel\Jobqueue\Collection;
use Magento\Framework\App\ResourceConnection;

/**
 * Class Hydration
 *
 * Abstract class inherited by all hydration workers (to Fastmag and to Magento)
 */
abstract class Hydration extends Worker
{
    /** @var Collection $jobs */
    protected $jobs;

    /** @var Config $config */
    protected $config;

    /**
     * Hydration constructor.
     *
     * @param Logger             $logger
     * @param ResourceConnection $resourceConnection
     * @param Collection         $jobs
     * @param Config             $config
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        Collection $jobs,
        Config $config
    ) {
        parent::__construct($logger, $resourceConnection);

        $this->jobs = $jobs;
        $this->config = $config;
    }

    /**
     * Get jobs
     *
     * @return Collection
     */
    public function getJobs()
    {
        return $this->jobs;
    }

    /**
     * Set jobs
     *
     * @param Collection $jobs
     *
     * @return self
     */
    public function setJobs($jobs)
    {
        $this->jobs = $jobs;

        return $this;
    }

    /**
     * Get config limit for hydration
     *
     * @return string
     */
    protected function getLimit()
    {
        return $this->config->getValue(Config::XML_PATH_JOBQUEUE_ADVANCED_HYDRATION_SIZE);
    }
}
