<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-07-27
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Worker;

use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Jobqueue as Job;
use Fastmag\Sync\Model\Process\Worker;
use Fastmag\Sync\Model\ResourceModel\Jobqueue\Collection;
use Magento\Framework\App\ResourceConnection;

/**
 * Class Integration
 *
 * Abstract class inherited by all integration workers (to Fastmag and to Magento)
 */
abstract class Integration extends Worker
{
    /** @var Config $config */
    protected $config;

    /** @var Collection $jobs */
    protected $jobs;

    /** @var array $errors */
    protected $errors = [];

    /** @var array $success */
    protected $success = [];

    /**
     * Customer constructor.
     *
     * @param Logger             $logger
     * @param ResourceConnection $resourceConnection
     * @param Config             $config
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        Config $config
    ) {
        parent::__construct($logger, $resourceConnection);

        $this->config = $config;
    }

    /**
     * @return Collection
     */
    public function getJobs()
    {
        return $this->jobs;
    }

    /**
     * @param Collection $jobs
     *
     * @return self
     */
    public function setJobs($jobs)
    {
        $this->jobs = $jobs;

        return $this;
    }

    /**
     * @return array
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @return int
     */
    public function getErrorsCount()
    {
        return count($this->errors);
    }

    /**
     * @param Job $job
     *
     * @return bool
     */
    public function isJobInError($job)
    {
        $result = false;

        if ($job->getId() && $this->getErrorsCount() && array_key_exists($job->getId(), $this->getErrors())) {
            $result = true;
        }

        return $result;
    }

    /**
     * Returns the activation of the synchronization of the current entity
     *
     * @return bool
     */
    public function isEnabled()
    {
        return true;
    }
}
