<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-06-11
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Worker\RemoteSync;

use DateInterval;
use DateTime;
use Exception;
use Fastmag\Sync\Exception\NoConnectionException;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Process\Worker;
use Fastmag\Sync\Model\System\Connection\Proxy;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\DB\Adapter\Pdo\Mysql;
use Zend_Db_Exception;

/**
 * Class Clean
 *
 * Worker class used for cleaning obsolete lines from queue table in Fastmag DB
 */
class Clean extends Worker
{
    /** @inheritDoc */
    protected $code = 'remotesync_clean';

    /** @var Proxy $proxy */
    protected $proxy;

    /**
     * Clean constructor
     *
     * @param Logger             $logger
     * @param ResourceConnection $resourceConnection
     * @param Proxy              $proxy
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        Proxy $proxy
    ) {
        parent::__construct($logger, $resourceConnection);

        $this->proxy = $proxy;
    }

    /**
     * @inheritDoc
     */
    public function run()
    {
        try {
            $now = new DateTime();
            $lastCleaningDate = $this->getLastExecutionDate();

            if ($lastCleaningDate->format(Mysql::DATE_FORMAT) === '1970-01-01') {
                $lastCleaningDate = new DateTime();
                $lastCleaningDate->sub(new DateInterval('PT14H'));
            } else {
                $lastCleaningDate->add(new DateInterval('PT12H'));
            }
        } catch (Exception $e) {
            return;
        }

        if ($now > $lastCleaningDate) {
            $this->logger->debug(
                'Clean old events twice a day - ' . $lastCleaningDate->format(Mysql::DATETIME_FORMAT)
            );

            $query = 'DELETE FROM fmsync_job_queue
                WHERE date_maj < \'' . $lastCleaningDate->format(Mysql::DATE_FORMAT) . '\'';

            $this->logger->debug($query);

            try {
                $result = $this->proxy->getConnection()->post($query);

                if ($result) {
                    $this->setLastExecutionDate();
                }
            } catch (NoConnectionException $e) {
                $this->logger->alert('Unable to connect with Fastmag database.');
            } catch (Zend_Db_Exception $e) {
                $this->logger->alert('Unable to connect with Fastmag database: ' . $e->getMessage());
            }
        }
    }
}
