<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-17
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Worker\ToFastmag;

use Fastmag\Sync\Exception\NoConnectionException;
use Fastmag\Sync\Model\Process\Worker\Hydration as AbstractHydration;
use Fastmag\Sync\Model\ResourceModel\Jobqueue\ToFastmag\Collection;
use Fastmag\Sync\Model\System\Connection\Proxy\SqlInterface;

/**
 * Class Hydration
 *
 * Abstract class inherited by all ToFastmag hydration workers
 *
 * @property Collection $jobs
 */
abstract class Hydration extends AbstractHydration
{
    /**
     * Run the queries to Magento returns the data as an array
     *
     * @return array
     */
    abstract protected function getDataFromMagento();

    /**
     * Check if the connection to Fastmag is working
     *
     * @return SqlInterface|false
     *
     * @throws NoConnectionException
     */
    protected function getConnection()
    {
        $result = false;

        if ($this->proxy->getConnection()->connect()) {
            $result = $this->proxy->getConnection();
        }

        return $result;
    }
}
