<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-26
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Worker\ToFastmag\Hydration\Customer;

use Exception;
use Fastmag\Sync\Exception\ProcessException;
use Fastmag\Sync\Model\Process\Worker\ToFastmag\Hydration\Customer;

/**
 * Class Delete
 *
 * Hydration class used for deleting customers from Magento to Fastmag
 */
class Delete extends Customer
{
    /** @inheritDoc */
    protected $code = 'tofastmag_hydration_customer_delete';

    /**
     * Get Magento data for the current jobs
     *
     * @return void
     *
     * @throws ProcessException
     */
    protected function getMagentoCustomersData()
    {
        $searchCriteria = $this->searchCriteriaBuilder
            ->addFilter('entity_id', $this->customersIds, 'in')
            ->create();

        try {
            $customersList = $this->customerRepository->getList($searchCriteria);

            foreach ($customersList->getItems() as $customer) {
                $customerData = [
                    'email'      => $customer->getEmail(),
                    'website_id' => $customer->getWebsiteId(),
                    'store_id'   => $customer->getStoreId(),
                ];

                foreach ($customerData as $field => $value) {
                    $this->hydratedData[$customer->getId()][$field] = $value;
                }
            }
        } catch (Exception $e) {
            throw new ProcessException(
                'Error when hydrating customers. Message: %1. Customers IDs: %2',
                $e->getMessage(),
                implode(', ', $this->customersIds)
            );
        }
    }
}
