<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-17
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Worker\ToFastmag;

use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Jobqueue\ToFastmagRepository as JobRepository;
use Fastmag\Sync\Model\Process\Worker\Integration as AbstractIntegration;
use Fastmag\Sync\Model\System\Connection\Edi;
use Magento\Framework\App\ResourceConnection;

/**
 * Class Integration
 *
 * @package Fastmag\Sync\Model\Process\Worker\ToFastmag
 */
abstract class Integration extends AbstractIntegration
{
    public const DEFAULT_REFERER = 'magento';

    /** @var JobRepository $jobRepository */
    protected $jobRepository;

    /** @var Edi $edi */
    protected $edi;

    /**
     * Integration constructor.
     *
     * @param Logger             $logger
     * @param ResourceConnection $resourceConnection
     * @param Config             $config
     * @param JobRepository      $jobRepository
     * @param Edi                $edi
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        Config $config,
        JobRepository $jobRepository,
        Edi $edi
    ) {
        parent::__construct($logger, $resourceConnection, $config);

        $this->jobRepository = $jobRepository;
        $this->edi = $edi;
    }
}
