<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-17
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Worker\ToMagento\Hydration;

use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Process\Entity\ToMagento\Customer\AddressFactory as AddressEntityFactory;
use Fastmag\Sync\Model\Process\Worker\ToMagento\Hydration;
use Fastmag\Sync\Model\ResourceModel\Jobqueue\ToMagento\Collection;
use Fastmag\Sync\Model\System\Connection\Proxy;
use Magento\Framework\App\ResourceConnection;

/**
 * Class Address
 *
 * Hydration class used for inserting or updating customers addresses from Fastmag to Magento
 * Called from Address hydration worker only
 */
class Address extends Hydration
{
    /** @inheritDoc */
    protected $code = 'tomagento_hydration_address';

    /** @var AddressEntityFactory $addressEntityFactory */
    protected $addressEntityFactory;

    /**
     * Address constructor.
     *
     * @param Logger               $logger
     * @param ResourceConnection   $resourceConnection
     * @param Collection           $jobs
     * @param Config               $config
     * @param Proxy                $proxy
     * @param AddressEntityFactory $addressEntityFactory
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        Collection $jobs,
        Config $config,
        Proxy $proxy,
        AddressEntityFactory $addressEntityFactory
    ) {
        parent::__construct($logger, $resourceConnection, $jobs, $config, $proxy);

        $this->addressEntityFactory = $addressEntityFactory;
    }

    /**
     * @inheritDoc
     */
    public function run()
    {
        // TODO: Implement run() method.
    }

    /**
     * @inheritDoc
     */
    protected function getDataFromFastmag()
    {
        // TODO: Implement getDataFromFastmag() method.
    }
}
