<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-17
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Worker\ToMagento;

use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Jobqueue\ToMagentoRepository as JobRepository;
use Fastmag\Sync\Model\Process\Worker\Integration as AbstractIntegration;
use Magento\Framework\App\ResourceConnection;

/**
 * Class Integration
 *
 * Abstract class inherited by all integration workers
 */
abstract class Integration extends AbstractIntegration
{
    /** @var JobRepository $jobRepository */
    protected $jobRepository;

    /**
     * Customer constructor.
     *
     * @param Logger             $logger
     * @param ResourceConnection $resourceConnection
     * @param Config             $config
     * @param JobRepository      $jobRepository
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        Config $config,
        JobRepository $jobRepository
    ) {
        parent::__construct($logger, $resourceConnection, $config);

        $this->jobRepository = $jobRepository;
    }
}
