<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Worker\ToMagento\Integration\Address;

use Fastmag\Sync\Exception\JobException;
use Fastmag\Sync\Model\Process\Entity\ToMagento\AddressInterface as AddressEntityInterface;
use Fastmag\Sync\Model\Process\Worker\ToMagento\Integration\Address;

/**
 * Class Save
 *
 * Integration worker for tomagento_integration_address_create and tomagento_integration_address_update jobs
 */
class Save extends Address
{
    /** @inheritDoc */
    protected $code = 'tomagento_integration_address_save';

    /**
     * @inheritDoc
     */
    public function run()
    {
        // @todo
    }

    /**
     * Check if address has street, postcode and city filled at least
     *
     * @param AddressEntityInterface $address
     *
     * @return bool
     *
     * @throws JobException
     */
    protected function isAddressValid($address)
    {
        if ($address->getStreet() === null) {
            throw new JobException(__('The address given does not have the street fields filled'));
        }

        if ($address->getPostcode() === null) {
            throw new JobException(__('The address given does not have post code field filled'));
        }

        if ($address->getCity() === null) {
            throw new JobException(__('The address given does not have the city field filled'));
        }

        return true;
    }
}
