<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-07-13
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Worker\ToMagento\Integration;

use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Process\Worker\ToMagento\Integration;

/**
 * Class Customer
 *
 * Abstract class for Order related Integration workers
 */
abstract class Order extends Integration
{
    /**
     * @inheritDoc
     */
    public function isEnabled()
    {
        return $this->config->isSetFlag(Config::XML_PATH_CUSTOMER_IMPORT_ENABLE)
            && $this->config->isSetFlag(Config::XML_PATH_CUSTOMER_IMPORT_SHOP_PURCHASES);
    }
}
