<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-03-26
 ******************************************************************************/

namespace Fastmag\Sync\Plugin\Jobqueue\Order;

use Exception;
use Fastmag\Sync\Plugin\Jobqueue\ToFastmag;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\Order\Creditmemo;
use Magento\Sales\Model\Order\Creditmemo\Item;
use Magento\Sales\Model\Order\Payment;

/**
 * Class Refund
 *
 * @package Fastmag\Sync\Plugin\Jobqueue\Order
 */
class Refund extends ToFastmag
{
    /**
     * @see Payment::refund()
     *
     * @param Payment $subject
     * @param Payment $result
     * @param Creditmemo $creditmemo
     *
     * @return Payment
     *
     * @throws Exception
     */
    public function afterRefund(Payment $subject, $result, $creditmemo)
    {
        if ($creditmemo->getTransactionId()) {
            /** @var Order $order */
            $order = $result->getOrder();

            if (!$order || !$order->getId()) {
                return $result;
            }

            $itemIds = array();
            /** @var Item $item */
            foreach ($creditmemo->getItemsCollection() as $item) {
                $itemIds[$item->getOrderItemId()] = $item->getData();
            }

            $datas = array(
                'customerId' => $order->getCustomerId(),
                'orderData' => $order->getData(),
                'orderTotalDue' => $order->getTotalDue(),
                'idRefund' => $creditmemo->getId(),
                'incrementIdRefund' => $creditmemo->getIncrementId(),
                'grandTotal' => $creditmemo->getGrandTotal(),
                'baseShippingInclTax' => $creditmemo->getBaseShippingInclTax(),
                'itemsRefund' => $itemIds
            );

            $job = $this->jobFactory->create();
            $job->setContentId($order->getId())
                ->setJobCode('tofastmag_entity_order_refund')
                ->setContent(serialize($datas));

            $this->jobRepository->save($job);
        }

        return $result;
    }
}
