<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-03-26
 ******************************************************************************/

namespace Fastmag\Sync\Plugin\Jobqueue\Order;

use Exception;
use Fastmag\Sync\Api\Jobqueue\ToFastmagRepositoryInterface;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Plugin\Jobqueue\ToFastmag;
use Fastmag\Sync\Model\DataPersistor;
use Fastmag\Sync\Model\Jobqueue\ToFastmagFactory;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Model\Order;

/**
 * Class Save
 *
 * @package Fastmag\Sync\Plugin\Jobqueue\Order
 */
class Save extends ToFastmag
{
    /** @var DataPersistor */
    protected $dataPersistor;

    /**
     * Save contructor
     *
     * @param ToFastmagFactory $jobFactory
     * @param ToFastmagRepositoryInterface $jobRepository
     * @param Logger $logger
     * @param DataPersistor $dataPersistor
     */
    public function __construct(
        ToFastmagFactory $jobFactory,
        ToFastmagRepositoryInterface $jobRepository,
        Logger $logger,
        DataPersistor $dataPersistor
    )
    {
        parent::__construct($jobFactory, $jobRepository, $logger);

        $this->dataPersistor = $dataPersistor;
    }

    /**
     * @see OrderRepositoryInterface::save()
     *
     * @param OrderRepositoryInterface $subject
     * @param OrderInterface $result
     *
     * @return OrderInterface
     *
     * @throws Exception
     */
    public function afterSave(OrderRepositoryInterface $subject, $result)
    {
        if ($result->getEntityId() && $result->getPayment()) {
            // Do not queue first save order empty state
            $state = $result->getState();

            if (!in_array($state, ['', Order::STATE_CLOSED, Order::STATE_CANCELED], true)) {
                $key = $result->getEntityId() . $state;

                // Avoid multiple fire at once
                if ($this->dataPersistor->get($key) === null) {
                    return $result;
                }

                try {
                    $orderData = array(
                        'state' => $state,
                        'status' => $result->getStatus()
                    );

                    $job = $this->jobFactory->create();
                    $job->setContentId($result->getEntityId())
                        ->setJobCode('tofastmag_entity_order_save')
                        ->setContent(serialize($orderData));

                    $this->jobRepository->save($job);

                    $this->dataPersistor->set($key, true);
                } catch (Exception $e) {
                    $this->logger->error($e->getMessage());
                }
            }
        }

        return $result;
    }
}
