<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-22
 ******************************************************************************/

namespace Fastmag\Sync\Plugin\Jobqueue;

use Fastmag\Sync\Api\Jobqueue\ToFastmagRepositoryInterface as JobRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Jobqueue\ToFastmagFactory as JobFactory;

/**
 * Class ToFastmag
 *
 * @package Fastmag\Sync\Plugin\Jobqueue
 */
abstract class ToFastmag
{
    /** @var JobFactory */
    protected $jobFactory;

    /** @var JobRepository */
    protected $jobRepository;

    /** @var Logger */
    protected $logger;

    /**
     * ToFastmag contructor
     *
     * @param JobFactory    $jobFactory
     * @param JobRepository $jobRepository
     * @param Logger        $logger
     */
    public function __construct(
        JobFactory $jobFactory,
        JobRepository $jobRepository,
        Logger $logger
    ) {
        $this->jobFactory = $jobFactory;
        $this->jobRepository = $jobRepository;
        $this->logger = $logger;
    }
}
