<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-06-17
 ******************************************************************************/

namespace Fastmag\Sync\Setup;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Zend_Db_Exception;

/**
 * Class InstallSchema
 *
 * First schema installer
 */
class InstallSchema implements InstallSchemaInterface
{
    /**
     * Main method
     *
     * @param SchemaSetupInterface   $setup
     * @param ModuleContextInterface $context
     *
     * @throws Zend_Db_Exception
     */
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();

        $tableName = $setup->getTable('fastmag_sync_rule_storeseller');

        if ($setup->getConnection()->isTableExists($tableName) !== true) {
            $table = $setup->getConnection()
                ->newTable($tableName)
                ->addColumn(
                    'rule_id',
                    Table::TYPE_INTEGER,
                    null,
                    [
                        'identity' => true,
                        'unsigned' => true,
                        'nullable' => false,
                        'primary'  => true
                    ],
                    'Rule ID'
                )
                ->addColumn(
                    'website_id',
                    Table::TYPE_INTEGER,
                    null,
                    [
                        'unsigned' => true,
                        'nullable' => false
                    ],
                    'Website ID'
                )
                ->addColumn(
                    'store_id',
                    Table::TYPE_INTEGER,
                    null,
                    [
                        'unsigned' => true,
                        'nullable' => false
                    ],
                    'Store ID'
                )
                ->addColumn(
                    'created_at',
                    Table::TYPE_TIMESTAMP,
                    null,
                    ['nullable' => false, 'default' => Table::TIMESTAMP_INIT],
                    'Created at'
                )
                ->addColumn(
                    'updated_at',
                    Table::TYPE_TIMESTAMP,
                    null,
                    ['nullable' => false, 'default' => Table::TIMESTAMP_INIT_UPDATE],
                    'Updated at'
                )
                ->addColumn(
                    'chain',
                    Table::TYPE_TEXT,
                    255,
                    ['nullable' => false],
                    'Chain'
                )
                ->addColumn(
                    'fastmag_shop',
                    Table::TYPE_TEXT,
                    255,
                    ['nullable' => false],
                    'Fastmag Shop'
                )
                ->addColumn(
                    'reference_stock',
                    Table::TYPE_TEXT,
                    255,
                    ['nullable' => false],
                    'Reference Stock'
                )
                ->addColumn(
                    'seller',
                    Table::TYPE_TEXT,
                    255,
                    ['nullable' => false],
                    'Seller'
                )
                ->addColumn(
                    'coefficient',
                    Table::TYPE_DECIMAL,
                    '12,4',
                    [
                        'unsigned' => false,
                        'nullable' => false,
                        'default'  => 1
                    ],
                    'Coefficient'
                )
                ->addColumn(
                    'rate_code',
                    Table::TYPE_TEXT,
                    255,
                    ['nullable' => false],
                    'Rate Code'
                )
                ->addColumn(
                    'seller_alternatives',
                    Table::TYPE_BLOB,
                    null,
                    ['nullable' => true],
                    'Allow to change seller on the fly regarding to rules defined in this field'
                )
                ->addColumn(
                    'stock_algorithm',
                    Table::TYPE_TEXT,
                    255,
                    ['nullable' => true],
                    'Stock Calculation Algorithm'
                )
                ->setComment('Fastmag Sync Store Seller Binding Table');

            $setup->getConnection()->createTable($table);
        }

        $setup->endSetup();
    }
}
