<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-09-28
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data\Rule;

/**
 * Interface StoresellerInterface
 */
interface StoresellerInterface
{
    /** @var string */
    public const RULE_ID = 'rule_id';

    /** @var string */
    public const WEBSITE_ID = 'website_id';

    /** @var string */
    public const STORE_ID = 'store_id';

    /** @var string */
    public const CREATED_AT = 'created_at';

    /** @var string */
    public const UPDATED_AT = 'updated_at';

    /** @var string */
    public const CHAIN = 'chain';

    /** @var string */
    public const FASTMAG_SHOP = 'fastmag_shop';

    /** @var string */
    public const REFERENCE_STOCK = 'reference_stock';

    /** @var string */
    public const SELLER = 'seller';

    /** @var string */
    public const COEFFICIENT = 'coefficient';

    /** @var string */
    public const RATE_CODE = 'rate_code';

    /** @var string */
    public const STOCK_ALGORITHM = 'stock_algorithm';

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * Get website ID
     *
     * @return int|null
     */
    public function getWebsiteId();

    /**
     * Get store ID
     *
     * @return int|null
     */
    public function getStoreId();

    /**
     * Get created at
     *
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * Get updated at
     *
     * @return string|null
     */
    public function getUpdatedAt();

    /**
     * Get chain
     *
     * @return string|null
     */
    public function getChain();

    /**
     * Get Fastmag shop
     *
     * @return string|null
     */
    public function getFastmagShop();

    /**
     * Get reference stock
     *
     * @return string|null
     */
    public function getReferenceStock();

    /**
     * Get seller
     *
     * @return string|null
     */
    public function getSeller();

    /**
     * Get coefficient
     *
     * @return float|null
     */
    public function getCoefficient();

    /**
     * Get rate code
     *
     * @return string|null
     */
    public function getRateCode();

    /**
     * Get seller alterantives
     *
     * @return string|null
     */
    public function getStockAlgorithm();

    /**
     * Set ID
     *
     * @param int $ruleId
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerInterface
     */
    public function setId($ruleId);

    /**
     * Set website ID
     *
     * @param int $websiteId
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerInterface
     */
    public function setWebsiteId($websiteId);

    /**
     * Set store ID
     *
     * @param int $storeId
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerInterface
     */
    public function setStoreId($storeId);

    /**
     * Set chain
     *
     * @param string $chain
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerInterface
     */
    public function setChain($chain);

    /**
     * Set Fastmag shop
     *
     * @param string $fastmagShop
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerInterface
     */
    public function setFastmagShop($fastmagShop);

    /**
     * Set reference stock
     *
     * @param string $referenceStock
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerInterface
     */
    public function setReferenceStock($referenceStock);

    /**
     * Set seller
     *
     * @param string $seller
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerInterface
     */
    public function setSeller($seller);

    /**
     * Get coefficient
     *
     * @param float $coefficient
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerInterface
     */
    public function setCoefficient($coefficient);

    /**
     * Set rate code
     *
     * @param string $rateCode
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerInterface
     */
    public function setRateCode($rateCode);

    /**
     * Set stock algorithm
     *
     * @param string $stockAlgorithm
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerInterface
     */
    public function setStockAlgorithm($stockAlgorithm);
}
