<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-17
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\System\Config\Connection;

use Exception;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\System\Connection\Sql\DirectSql;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;

/**
 * Class Triggers
 *
 * Controller allowing the reinstallaton of the triggers on Fastmag DB
 */
class Triggers extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::triggers';

    /** @var JsonFactory $resultJsonFactory */
    protected $resultJsonFactory;

    /** @var DirectSql $connection */
    protected $connection;

    /** @var Logger $logger s*/
    protected $logger;

    /**
     * Triggers constructor
     *
     * @param Context     $context
     * @param JsonFactory $resultJsonFactory
     * @param DirectSql   $connection
     * @param Logger      $logger
     */
    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        DirectSql $connection,
        Logger $logger
    ) {
        parent::__construct($context);

        $this->resultJsonFactory = $resultJsonFactory;
        $this->connection = $connection;
        $this->logger = $logger;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        try {
            $this->connection->reinstallTriggers();
            $result = [
                'triggers_reinstalled' => 1,
                'message' => __('The triggers have been reinstalled.')
            ];
        } catch (Exception $e) {
            $result = [
                'triggers_reinstalled' => 0,
                'message' => __('Unable to reinstall triggers. Error: %1', $e->getMessage())
            ];
        }

        $resultJson = $this->resultJsonFactory->create();

        return $resultJson->setData($result);
    }
}
