<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Logger;

use Fastmag\Sync\Api\LogRepositoryInterface;
use Fastmag\Sync\Model\LogFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Exception\LocalizedException;
use Monolog\Handler\HandlerInterface;
use Monolog\Logger as MonologLogger;

/**
 * Class Logger
 *
 * Dedicated logger class
 */
class Logger extends MonologLogger
{
    /** @var string */
    public const XML_CONFIG_LOG_ENABLE = 'fastmag_sync_logs/logs/enable';

    /** @var string */
    public const XML_CONFIG_LOG_TO_FILE = 'fastmag_sync_logs/logs/to_file';

    /** @var ScopeConfigInterface */
    protected $scopeConfig;

    /** @var LogFactory */
    protected $logFactory;

    /** @var LogRepositoryInterface */
    protected $logRepository;

    /**
     * Logger constructor.
     *
     * @param string                 $name
     * @param ScopeConfigInterface   $scopeConfig
     * @param LogFactory             $logFactory
     * @param LogRepositoryInterface $logRepository
     * @param HandlerInterface[]     $handlers
     * @param callable[]             $processors
     */
    public function __construct(
        $name,
        ScopeConfigInterface $scopeConfig,
        LogFactory $logFactory,
        LogRepositoryInterface $logRepository,
        array $handlers = [],
        array $processors = []
    ) {
        parent::__construct($name, $handlers, $processors);

        $this->scopeConfig = $scopeConfig;
        $this->logFactory = $logFactory;
        $this->logRepository = $logRepository;
    }

    /**
     * Log only ERROR, CRITICAL, ALERT, EMERGENCY level log if log disabled in configuration
     *
     * @inheritDoc
     *
     * @throws LocalizedException
     */
    public function addRecord($level, $message, array $context = [])
    {
        if ($level > self::WARNING || $this->scopeConfig->isSetFlag(self::XML_CONFIG_LOG_ENABLE)) {
            $log = $this->logFactory->create();
            $log->setMessage($message)
                ->setLevel($level);

            /* @todo create process to clean log table occasionally */
            $this->logRepository->save($log);

            if ($this->scopeConfig->isSetFlag(self::XML_CONFIG_LOG_TO_FILE)) {
                parent::addRecord($level, $message, $context);
            }
        }
    }
}
