<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-10-19
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Entity\Helper\Attribute;

use Fastmag\Sync\Model\Process\Entity\Helper\AttributeInterface;

/**
 * Class Prefix
 *
 * Helper class to help format prefix for Magento
 */
class Prefix implements AttributeInterface
{
    /** @var int $defaultFastmagValue */
    protected static $defaultFastmagValue = '';

    /** @var array $values */
    protected static $magentoValues = [
        'MADAME'       => 'MME',
        'MME'          => 'MME',
        'MADEMOISELLE' => 'MME',
        'MELLE'        => 'MME',
        'MONSIEUR'     => 'M',
        'M'            => 'M',
        'MR'           => 'M',
        'SOCIETE'      => 'STE'
    ];

    /** @var array $fastmagValues */
    protected static $fastmagValues = [
        'MME'   => 'MADAME',
        'MELLE' => 'MADAME',
        'M'     => 'MONSIEUR',
        'STE'   => 'SOCIETE'
    ];

    /**
     * @inheritDoc
     *
     * @param string $fastmagValue
     *
     * @return int|null
     */
    public static function getMagentoValue($fastmagValue)
    {
        $result = self::getDefaultMagentoValue();

        if (array_key_exists($fastmagValue, self::$magentoValues)) {
            $result = self::$magentoValues[$fastmagValue];
        }

        return $result;
    }

    /**
     * @inheritDoc
     *
     * @param string $fastmagValue
     *
     * @return int
     */
    public static function getFastmagValue($fastmagValue)
    {
        $result = self::getDefaultFastmagValue();

        if (array_key_exists($fastmagValue, self::$fastmagValues)) {
            $result = self::$fastmagValues[$fastmagValue];
        }

        return $result;
    }

    /**
     * @inheritDoc
     *
     * @return null
     */
    public static function getDefaultMagentoValue()
    {
        return null;
    }

    /**
     * @inheritDoc
     *
     * @return string
     */
    public static function getDefaultFastmagValue()
    {
        return self::$defaultFastmagValue;
    }
}
