<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-10-15
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Entity\ToFastmag;

use Fastmag\Sync\Model\Process\EntityInterface;
use Fastmag\Sync\Model\Process\Entity\Helper\Attribute\Prefix;

/**
 * Class Address
 *
 * Entity class for address.
 * Save and transform data from Magento for Fastmag easy integration,
 * and transfer it from hydration worker to integration worker
 */
class Address implements EntityInterface
{
    /** @var string $alias */
    protected $alias;

    /** @var int $magentoId */
    protected $magentoId;

    /** @var string $prefix */
    protected $prefix;

    /** @var string $firstname */
    protected $firstname;

    /** @var string $lastname */
    protected $lastname;

    /** @var string $company */
    protected $company;

    /** @var string[] $street */
    protected $street;

    /** @var string $postcode */
    protected $postcode;

    /** @var string $city */
    protected $city;

    /** @var string $countryId */
    protected $countryId;

    /** @var string $phoneNumber */
    protected $phoneNumber;

    /** @var bool $archive */
    protected $archive;

    /**
     * Get alias
     *
     * @return string
     */
    public function getAlias()
    {
        return $this->alias;
    }

    /**
     * Get Magento ID
     *
     * @return int
     */
    public function getMagentoId()
    {
        return $this->magentoId;
    }

    /**
     * Get prefix
     *
     * @return string
     */
    public function getPrefix()
    {
        return Prefix::getFastmagValue($this->prefix);
    }

    /**
     * Get firstname
     *
     * @return string
     */
    public function getFirstname()
    {
        return $this->firstname;
    }

    /**
     * Get lastname
     *
     * @return string
     */
    public function getLastname()
    {
        return $this->lastname;
    }

    /**
     * Get company
     *
     * @return string
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Get street
     *
     * @return string[]
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * Get first line of street
     *
     * @return string
     */
    public function getStreetOne()
    {
        return $this->street[0];
    }

    /**
     * Get second line of street
     *
     * @return string
     */
    public function getStreetTwo()
    {
        return (count($this->street) > 1 ? $this->street[1] : '');
    }

    /**
     * Get postcode
     *
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }

    /**
     * Get city
     *
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * Get country ID
     *
     * @return string
     */
    public function getCountryId()
    {
        return $this->countryId;
    }

    /**
     * Get phone number
     *
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }

    /**
     * Is archived
     *
     * @return bool
     */
    public function isArchived()
    {
        return $this->archive;
    }

    /**
     * Set alias
     *
     * @param string $alias
     *
     * @return Address
     */
    public function setAlias($alias)
    {
        $this->alias = $alias;

        return $this;
    }

    /**
     * Set Magento ID
     *
     * @param int $magentoId
     *
     * @return Address
     */
    public function setMagentoId($magentoId)
    {
        $this->magentoId = $magentoId;

        return $this;
    }

    /**
     * Set prefix
     *
     * @param string $prefix
     *
     * @return Address
     */
    public function setPrefix($prefix)
    {
        $this->prefix = $prefix;

        return $this;
    }

    /**
     * Set firstname
     *
     * @param string $firstname
     *
     * @return Address
     */
    public function setFirstname($firstname)
    {
        $this->firstname = $firstname;

        return $this;
    }

    /**
     * Set lastname
     *
     * @param string $lastname
     *
     * @return Address
     */
    public function setLastname($lastname)
    {
        $this->lastname = $lastname;

        return $this;
    }

    /**
     * Set company
     *
     * @param string $company
     *
     * @return Address
     */
    public function setCompany($company)
    {
        $this->company = $company;

        return $this;
    }

    /**
     * Set street
     *
     * @param string[] $street
     *
     * @return Address
     */
    public function setStreet($street)
    {
        $this->street = $street;

        return $this;
    }

    /**
     * Set post code
     *
     * @param string $postcode
     *
     * @return Address
     */
    public function setPostcode($postcode)
    {
        $this->postcode = $postcode;

        return $this;
    }

    /**
     * Set city
     *
     * @param string $city
     *
     * @return Address
     */
    public function setCity($city)
    {
        $this->city = $city;

        return $this;
    }

    /**
     * Set country ID
     *
     * @param string $countryId
     *
     * @return Address
     */
    public function setCountryId($countryId)
    {
        $this->countryId = $countryId;

        return $this;
    }

    /**
     * Set phone number
     *
     * @param string $phoneNumber
     *
     * @return Address
     */
    public function setPhoneNumber($phoneNumber)
    {
        $this->phoneNumber = $phoneNumber;

        return $this;
    }

    /**
     * Set phone number
     *
     * @param bool $archive
     *
     * @return Address
     */
    public function setArchived($archive)
    {
        $this->archive = $archive;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function export()
    {
        return [
            'alias'     => $this->getAlias(),
            'lastname'  => $this->getLastname(),
            'firstname' => $this->getFirstname(),
            'company'   => $this->getCompany(),
            'street1'   => $this->getStreet()[0],
            'street2'   => (count($this->getStreet() > 1) ? $this->getStreet()[1] : null),
            'postcode'  => $this->getPostcode(),
            'city'      => $this->getCity(),
            'country'   => $this->getCountryId(),
            'phone'     => $this->getPhoneNumber(),
            'archive'   => $this->isArchived()
        ];
    }
}
