<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-10-08
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Entity\ToMagento\Customer;

use Fastmag\Sync\Helper\Text;
use Fastmag\Sync\Model\Process\Entity\Helper\Attribute\Prefix;

/**
 * Class Address
 *
 * Entity class for customer address.
 * Save and transform data from Fastmag for Magento easy integration,
 * and transfer it from hydration worker to integration worker
 *
 * @deprecated Data formatting will be done on integration worker
 */
class Address
{
    /** @var string $alias */
    protected $alias;

    /** @var int $magentoId */
    protected $magentoId;

    /** @var int $customerFastmagId */
    protected $customerFastmagId;

    /** @var string $prefix */
    protected $prefix;

    /** @var string $firstname */
    protected $firstname;

    /** @var string $lastname */
    protected $lastname;

    /** @var string $company */
    protected $company;

    /** @var string $streetOne */
    protected $streetOne;

    /** @var string $streetTwo */
    protected $streetTwo;

    /** @var string $postcode */
    protected $postcode;

    /** @var string $city */
    protected $city;

    /** @var string $countryId */
    protected $countryId;

    /** @var string $phoneNumber */
    protected $phoneNumber;

    /** @var string $mobilePhoneNumber */
    protected $mobilePhoneNumber;

    /** @var bool $isLastShipping */
    protected $isLastShipping;

    /**
     * Get alias
     *
     * @return string
     */
    public function getAlias()
    {
        return $this->alias;
    }

    /**
     * Get Magento ID
     *
     * @return int
     */
    public function getMagentoId()
    {
        return $this->magentoId;
    }

    /**
     * @inheritDoc
     */
    public function getCustomerFastmagId()
    {
        return (int)$this->customerFastmagId;
    }

    /**
     * @inheritDoc
     */
    public function getPrefix()
    {
        return Prefix::getMagentoValue(Text::upper($this->prefix));
    }

    /**
     * @inheritDoc
     */
    public function getFirstname()
    {
        $result = $this->firstname;

        if (empty($this->firstname) && !empty($this->lastname)) {
            $names = explode(' ', $this->lastname);
            $result = array_pop($names);
        }

        return Text::capitalize($result);
    }

    /**
     * @inheritDoc
     */
    public function getLastname()
    {
        $result = $this->lastname;

        if (empty($this->firstname) && !empty($this->lastname)) {
            $names = explode(' ', $this->lastname);
            array_pop($names);
            $result = implode(' ', $names);

        }

        return Text::capitalize($result);
    }

    /**
     * @inheritDoc
     */
    public function getCompany()
    {
        return Text::lower($this->company);
    }

    /**
     * @inheritDoc
     */
    public function getStreet()
    {
        return ['0' => Text::lower($this->streetOne), '1' => Text::lower($this->streetTwo)];
    }

    /**
     * @inheritDoc
     */
    public function getPostcode()
    {
        return Text::lower($this->postcode);
    }

    /**
     * @inheritDoc
     */
    public function getCity()
    {
        return Text::capitalize($this->city);
    }

    /**
     * @inheritDoc
     */
    public function getContryId()
    {
        return Text::upper($this->countryId ?? 'fr');
    }

    /**
     * @inheritDoc
     */
    public function getPhoneNumber()
    {
        $result = $this->phoneNumber;

        if (!empty($this->mobilePhoneNumber) && $this->mobilePhoneNumber !== $this->phoneNumber) {
            $result = $this->mobilePhoneNumber;
        }

        return Text::lower($result);
    }

    /**
     * Return true if it's the last shipping address used by the customer, false otherwise
     *
     * @return bool
     */
    public function isLastShipping()
    {
        return $this->isLastShipping;
    }

    /**
     * Set alias
     *
     * @param string $alias
     *
     * @return self
     */
    public function setAlias($alias)
    {
        $this->alias = $alias;

        return $this;
    }

    /**
     * Set Magento ID
     *
     * @param int $magentoId
     *
     * @return self
     */
    public function setMagentoId($magentoId)
    {
        $this->magentoId = $magentoId;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setCustomerFastmagId($fastmagId)
    {
        $this->customerFastmagId = $fastmagId;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setPrefix($prefix)
    {
        $this->prefix = $prefix;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setFirstname($firstname)
    {
        $this->firstname = $firstname;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setLastname($lastname)
    {
        $this->lastname = $lastname;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setCompany($company)
    {
        $this->company = $company;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setStreetOne($streetOne)
    {
        $this->streetOne = $streetOne;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setStreetTwo($streetTwo)
    {
        $this->streetTwo = $streetTwo;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setPostcode($postcode)
    {
        $this->postcode = $postcode;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setCity($city)
    {
        $this->city = $city;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setCountryId($countryId)
    {
        $this->countryId = $countryId;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setPhoneNumber($phoneNumber)
    {
        $this->phoneNumber = $phoneNumber;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setMobilePhoneNumber($mobilePhoneNumber)
    {
        $this->mobilePhoneNumber = $mobilePhoneNumber;

        return $this;
    }

    /**
     * Set true if it's the last shipping address used by the customer, false otherwise
     *
     * @param $value
     *
     * @return self
     */
    public function setIsLastShipping($value)
    {
        $this->isLastShipping = $value;

        return $this;
    }
}
