<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-10-15
 ******************************************************************************/

namespace Fastmag\Sync\Model\Process\Worker\ToFastmag\Hydration;

use Fastmag\Sync\Api\CustomerRepositoryInterface as SyncedCustomerRepository;
use Fastmag\Sync\Api\Data\CustomerInterface as SyncedCustomerInterface;
use Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface as Job;
use Fastmag\Sync\Api\Jobqueue\ToFastmagRepositoryInterface as JobRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Process\Entity\ToFastmag\Customer as CustomerEntity;
use Fastmag\Sync\Model\Process\Entity\ToFastmag\CustomerFactory as CustomerEntityFactory;
use Fastmag\Sync\Model\Process\Worker\ToFastmag\Hydration;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\App\ResourceConnection;

/**
 * Class Customer
 *
 * Hydration class used for inserting or updating customers from Magento to Fastmag
 */
abstract class Customer extends Hydration
{
    /** @var SyncedCustomerRepository $syncedCustomerRepository */
    protected $syncedCustomerRepository;

    /** @var SearchCriteriaBuilder $searchCriteriaBuilder */
    protected $searchCriteriaBuilder;

    /** @var CustomerRepositoryInterface $customerRepository */
    protected $customerRepository;

    /** @var JobRepository $jobRepository */
    protected $jobRepository;

    /** @var CustomerEntityFactory $customerEntityFactory */
    protected $customerEntityFactory;

    /** @var CustomerEntity[] $entities */
    protected $entities;

    /**
     * Customer constructor.
     *
     * @param Logger                      $logger
     * @param ResourceConnection          $resourceConnection
     * @param Config                      $config
     * @param SyncedCustomerRepository    $syncedCustomerRepository
     * @param SearchCriteriaBuilder       $searchCriteriaBuilder
     * @param CustomerRepositoryInterface $customerRepository
     * @param JobRepository               $jobRepository
     * @param CustomerEntityFactory       $customerEntityFactory
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        Config $config,
        SyncedCustomerRepository $syncedCustomerRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        CustomerRepositoryInterface $customerRepository,
        JobRepository $jobRepository,
        CustomerEntityFactory $customerEntityFactory
    ) {
        parent::__construct($logger, $resourceConnection, $config);

        $this->syncedCustomerRepository = $syncedCustomerRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->customerRepository = $customerRepository;
        $this->jobRepository = $jobRepository;
        $this->customerEntityFactory = $customerEntityFactory;
    }

    /**
     * Get synced Fastmag ids for the current jobs
     *
     * @param int[] $customerIds
     *
     * @return void
     */
    protected function getSyncedCustomers($customerIds)
    {
        $searchCriteria = $this->searchCriteriaBuilder
            ->addFilter(SyncedCustomerInterface::MAGENTO_CUSTOMER_ID, $customerIds, 'in')
            ->create();

        $syncedCustomerList = $this->syncedCustomerRepository->getList($searchCriteria);

        foreach ($syncedCustomerList->getItems() as $syncedCustomer) {
            $currentEntity = $this->entities[$syncedCustomer->getMagentoCustomerId()];
            $currentEntity->setFastmagId($syncedCustomer->getFastmagCustomerId());
        }
    }

    /**
     * Returns the job for the current customer ID hydrated
     *
     * @param int $customerId
     *
     * @return Job
     */
    protected function getJob($customerId)
    {
        return $this->jobs->getItemByColumnValue(Job::CONTENT_ID, $customerId);
    }
}
