<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-10-01
 ******************************************************************************/

namespace Fastmag\Sync\Model\System\Connection\Sql;

use Fastmag\Sync\Exception\NoConnectionException;

/**
 * Interface SqlInterface
 *
 * @todo implements prepared queries on both SqlInterfaces (Direct et EDI)
 */
interface SqlInterface
{
    /**
     * Connect to the defined Fastmag SQL interface (EDI-SQL or direct SQL)
     *
     * @return bool
     *
     * @throws NoConnectionException
     */
    public function connect();

    /**
     * Execute SELECT query to the defined SQL Fastmag interface (EDI-SQL or direct SQL)
     * Returns the array as PDO::FETCH_NUM
     *
     * @param string $sql
     *
     * @return array
     *
     * @throws NoConnectionException
     */
    public function get($sql);

    /**
     * Execute UPDATE/INSERT/DELETE/DROP query to the defined SQL Fastmag interface (EDI-SQL or direct SQL)
     *
     * @param string $sql
     *
     * @return bool
     *
     * @throws NoConnectionException
     */
    public function post($sql);

    /**
     * Execute UPDATE/INSERT/DELETE/DROP query to the defined SQL Fastmag interface (EDI-SQL or direct SQL)
     * Used only for the triggers creation
     *
     * @see \Magento\Framework\DB\Adapter\Pdo\Mysql::multiQuery
     *
     * @param string $sql
     *
     * @return bool
     *
     * @throws NoConnectionException
     */
    public function multiPost($sql);

    /**
     * Sanitize data which will be injected into SQL query
     *
     * @param string|int|float|array $value
     * @param bool                   $forceString
     *
     * @return string
     *
     * @todo > 1.0.0 : replace with PDO prepared queries, or actual webservice and not SQL queries...
     */
    public function escape($value, $forceString = false);
}
