<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-03-26
 ******************************************************************************/

namespace Fastmag\Sync\Plugin\Jobqueue\Order;

use Exception;
use Fastmag\Sync\Plugin\Jobqueue\ToFastmag;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Model\Order;

/**
 * Class Cancel
 *
 * @package Fastmag\Sync\Plugin\Jobqueue\Order
 */
class Cancel extends ToFastmag
{
    /**
     * @see Order::cancel()
     *
     * @param Order $subject
     * @param OrderInterface $result
     *
     * @return OrderInterface
     *
     * @throws Exception
     */
    public function afterCancel(Order $subject, $result)
    {
        if ($result->isCanceled()) {
            try {
                $orderData = array(
                    'state' => $result->getState(),
                    'status' => $result->getStatus()
                );

                $job = $this->jobFactory->create();
                $job->setContentId($result->getEntityId())
                    ->setJobCode('tofastmag_entity_order_cancel')
                    ->setContent(serialize($orderData));

                $this->jobRepository->save($job);
            } catch (Exception $e) {
                $this->logger->error($e->getMessage());
            }
        }

        return $result;
    }
}
