<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-24
 ******************************************************************************/

namespace Fastmag\Sync\Plugin\Jobqueue\ToFastmag;

use Fastmag\Sync\Api\Data\Jobqueue\ToFastmagInterface as Job;
use Fastmag\Sync\Api\Jobqueue\ToFastmagRepositoryInterface as JobRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Jobqueue\ToFastmagFactory as JobFactory;
use Fastmag\Sync\Plugin\Jobqueue\ToFastmag;
use Magento\Customer\Api\CustomerRepositoryInterface as CustomerRepository;
use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\Exception\CouldNotDeleteException;
use Magento\Framework\Exception\CouldNotSaveException;

/**
 * Class CustomerRepositoryPlugin
 *
 * Plugin on CustomerRepositoryInterface
 */
class CustomerRepositoryPlugin extends ToFastmag
{
    /** @var Config $config */
    protected $config;

    /** @var SearchCriteriaBuilder $searchCriteriaBuilder */
    protected $searchCriteriaBuilder;

    /**
     * Save contructor
     *
     * @param JobFactory            $jobFactory
     * @param JobRepository         $jobRepository
     * @param Logger                $logger
     * @param Config                $config
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     */
    public function __construct(
        JobFactory $jobFactory,
        JobRepository $jobRepository,
        Logger $logger,
        Config $config,
        SearchCriteriaBuilder $searchCriteriaBuilder
    ) {
        parent::__construct($jobFactory, $jobRepository, $logger);

        $this->config = $config;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }

    /**
     * @see CustomerRepository::save()
     *
     * @param CustomerRepository $subject
     * @param CustomerInterface  $customer
     *
     * @return CustomerInterface
     *
     * @throws CouldNotDeleteException
     * @throws CouldNotSaveException
     */
    public function afterSave(CustomerRepository $subject, CustomerInterface $customer)
    {
        $customerId = $customer->getId();

        if ($customerId && $this->config->isSetFlag(Config::XML_PATH_CUSTOMER_IMPORT_ENABLE)) {
            $searchCriteria = $this->searchCriteriaBuilder->addFilter(Job::CONTENT_ID, $customerId)
                ->addFilter(Job::JOB_CODE, 'tofastmag_integration_customer_delete')
                ->create();

            $deletionJobsList = $this->jobRepository->getList($searchCriteria);

            if ($deletionJobsList->getTotalCount() > 0) {
                foreach ($deletionJobsList->getItems() as $deletionJob) {
                    $this->jobRepository->delete($deletionJob);
                }
            }

            $job = $this->jobFactory->create();
            $job->setContentId($customerId)
                ->setJobCode('tofastmag_integration_customer_save');

            $this->jobRepository->save($job);
        }

        return $customer;
    }

    /**
     * @see CustomerRepository::deleteById()
     *
     * @param CustomerRepository $subject
     * @param int                $customerId
     *
     * @return void
     *
     * @throws CouldNotDeleteException
     * @throws CouldNotSaveException
     */
    public function beforeDeleteById(
        CustomerRepository $subject,
        int $customerId
    ) {
        if ($customerId && $this->config->isSetFlag(Config::XML_PATH_CUSTOMER_IMPORT_ENABLE)) {
            $searchCriteria = $this->searchCriteriaBuilder->addFilter(Job::CONTENT_ID, $customerId)
                ->addFilter(Job::JOB_CODE, 'tofastmag_integration_customer_save')
                ->create();

            $savingJobsList = $this->jobRepository->getList($searchCriteria);

            if ($savingJobsList->getTotalCount() > 0) {
                foreach ($savingJobsList->getItems() as $savingJob) {
                    $this->jobRepository->delete($savingJob);
                }
            }

            $job = $this->jobFactory->create();
            $job->setContentId($customerId)
                ->setJobCode('tofastmag_integration_customer_delete');

            $this->jobRepository->save($job);
        }
    }
}
