<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-09-22
 ******************************************************************************/

namespace Fastmag\Sync\Plugin\Jobqueue\ToFastmag;

use Fastmag\Sync\Api\Jobqueue\ToFastmagRepositoryInterface as JobRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\DataPersistor;
use Fastmag\Sync\Model\Jobqueue\ToFastmagFactory as JobFactory;
use Fastmag\Sync\Plugin\Jobqueue\ToFastmag;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Serialize\Serializer\Serialize;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Model\Order;

/**
 * Class OrderRepositoryPlugin
 *
 * Plugin on OrderRepositoryInterface
 */
class OrderRepositoryPlugin extends ToFastmag
{
    /** @var DataPersistor */
    protected $dataPersistor;

    /** @var Serialize $serializer */
    protected $serializer;

    /**
     * Save contructor
     *
     * @param JobFactory    $jobFactory
     * @param JobRepository $jobRepository
     * @param Logger        $logger
     * @param DataPersistor $dataPersistor
     * @param Serialize     $serializer
     */
    public function __construct(
        JobFactory $jobFactory,
        JobRepository $jobRepository,
        Logger $logger,
        DataPersistor $dataPersistor,
        Serialize $serializer
    ) {
        parent::__construct($jobFactory, $jobRepository, $logger);

        $this->dataPersistor = $dataPersistor;
        $this->serializer = $serializer;
    }

    /**
     * @see OrderRepositoryInterface::save()
     *
     * @param OrderRepositoryInterface $subject
     * @param OrderInterface           $order
     *
     * @return OrderInterface
     */
    public function afterSave(OrderRepositoryInterface $subject, $order)
    {
        if ($order->getEntityId()
            && $order->getPayment()
            && !in_array($order->getState(), ['', Order::STATE_CLOSED, Order::STATE_CANCELED], true)
        ) {
            try {
                $key = $order->getEntityId() . '_' . $order->getStatus();

                $job = $this->jobFactory->create();
                $job->setContentId($key)
                    ->setJobCode('tofastmag_integration_order_save');

                $this->jobRepository->save($job);
            } catch (CouldNotSaveException $e) {
                $this->logger->error($e->getMessage());
            }
        }

        return $order;
    }
}
