<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-05-28
 ******************************************************************************/

namespace Fastmag\Sync\Block\Adminhtml\System\Config\Connection;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;

/**
 * Class Edi
 *
 * Config field block displaying EDI connection status
 *
 * @see \Magento\Customer\Block\Adminhtml\System\Config\Validatevat
 */
class Edi extends Field
{
    /** @var string $ediHostField */
    protected $ediHostField = 'fastmag_sync_connect_edi_host';

    /** @var string $ediPortField */
    protected $ediPortField = 'fastmag_sync_connect_edi_port';

    /** @var string $ediChainField */
    protected $ediChainField = 'fastmag_sync_connect_edi_chain';

    /** @var string $ediShopField */
    protected $ediShopField = 'fastmag_sync_connect_edi_shop';

    /** @var string $ediUserField */
    protected $ediUserField = 'fastmag_sync_connect_edi_user';

    /** @var string $ediPasswordField */
    protected $ediPasswordField = 'fastmag_sync_connect_edi_password';

    /** @var string $ediSslField */
    protected $ediSslField = 'fastmag_sync_connect_edi_ssl';

    /** @var string $buttonLabel */
    protected $buttonLabel = 'Test connection';

    /** @var string $ediResultField */
    protected $ediResultField = 'test_connection_edi_result';

    /** @var string $resultFieldPrefixId */
    protected $resultFieldPrefixId = 'result_fastmag_sync_connect_edi_connection_';

    /**
     * Get EDI Host Field Name
     *
     * @return string
     */
    public function getEdiHostField()
    {
        return $this->ediHostField;
    }

    /**
     * Get EDI Port Number Field
     *
     * @return string
     */
    public function getEdiPortField()
    {
        return $this->ediPortField;
    }

    /**
     * Get EDI Chain Field
     *
     * @return string
     */
    public function getEdiChainField()
    {
        return $this->ediChainField;
    }

    /**
     * Get EDI Shop Field
     *
     * @return string
     */
    public function getEdiShopField()
    {
        return $this->ediShopField;
    }

    /**
     * Get EDI User Number Field
     *
     * @return string
     */
    public function getEdiUserField()
    {
        return $this->ediUserField;
    }

    /**
     * Get EDI Password Field
     *
     * @return string
     */
    public function getEdiPasswordField()
    {
        return $this->ediPasswordField;
    }

    /**
     * Get EDI SSL Field
     *
     * @return string
     */
    public function getEdiSslField()
    {
        return $this->ediSslField;
    }

    /**
     * Get ID for field displaying the result of Fastmag EDI connection
     *
     * @return string
     */
    public function getEdiResultField()
    {
        return $this->ediResultField;
    }

    /**
     * Get ID for field displaying the result of Fastmag EDI connection
     *
     * @param string $suffix
     *
     * @return string
     */
    public function getResultFieldId($suffix)
    {
        return $this->resultFieldPrefixId . $suffix;
    }

    /**
     * @inheritDoc
     */
    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        $this->setTemplate('system/config/connection/edi.phtml');

        return $this;
    }

    /**
     * Unset some non-related element parameters
     *
     * @param AbstractElement $element
     *
     * @return string
     */
    public function render(AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();
        return parent::render($element);
    }

    /**
     * Get the button and scripts contents
     *
     * @param AbstractElement $element
     *
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        $originalData = $element->getOriginalData();
        $buttonLabel = !empty($originalData['button_label']) ? $originalData['button_label'] : $this->buttonLabel;
        $this->addData(
            [
                'button_label' => __($buttonLabel),
                'html_id' => $element->getHtmlId(),
                'ajax_url' => $this->_urlBuilder->getUrl('fastmagsync/system_config_connection/edi'),
            ]
        );

        return $this->_toHtml();
    }
}
