<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-06-04
 ******************************************************************************/

namespace Fastmag\Sync\Exception;

use Exception;

/**
 * Class ApiException
 *
 * Class handling Fastmag API related errors
 */
class ApiException extends Exception
{
    /** @var string $request */
    protected $request;

    /**
     * ApiException constructor.
     *
     * @param string $request
     * @param string $message
     * @param int    $code
     */
    public function __construct($request, $message = '', $code = 0)
    {
        parent::__construct($message, $code);

        $this->request = $request;
    }

    /**
     * Get raw request
     *
     * @return string
     */
    public function getRequest()
    {
        return $this->request;
    }
}
