<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Jobqueue;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class Status
 *
 * Source for job status config field
 */
class Status implements OptionSourceInterface
{
    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        return [
            ['value' => '1', 'label' => __('OK')],
            ['value' => '0', 'label' => __('Error')]
        ];
    }

    /**
     * Returns values as associative array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            '1' => __('OK'),
            '0' => __('Error')
        ];
    }
}