<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-09-28
 ******************************************************************************/

namespace Fastmag\Sync\Model\Rule;

use Fastmag\Sync\Api\Data\Rule\StoresellerInterface;
use Fastmag\Sync\Model\ResourceModel\Rule\Storeseller as ResourceModel;
use Magento\Framework\DataObject\IdentityInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Storeseller
 *
 * Storeseller rules model
 */
class Storeseller extends AbstractModel implements StoresellerInterface, IdentityInterface
{
    /** @var string */
    public const CACHE_TAG = 'fastmag_sync_rule_storeseller';

    /** @var string $_cacheTag */
    protected $_cacheTag = self::CACHE_TAG;

    /** @var string $_eventPrefix */
    protected $_eventPrefix = 'fastmag_sync_rule_storeseller';

    /**
     * Storeseller constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->getData(self::RULE_ID);
    }

    /**
     * @inheritDoc
     */
    public function getWebsiteId()
    {
        return $this->getData(self::WEBSITE_ID);
    }

    /**
     * @inheritDoc
     */
    public function getStoreId()
    {
        return $this->getData(self::STORE_ID);
    }

    /**
     * @inheritDoc
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getUpdatedAt()
    {
        return $this->getData(self::UPDATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getChain()
    {
        return $this->getData(self::CHAIN);
    }

    /**
     * @inheritDoc
     */
    public function getFastmagShop()
    {
        return $this->getData(self::FASTMAG_SHOP);
    }

    /**
     * @inheritDoc
     */
    public function getReferenceStock()
    {
        return $this->getData(self::REFERENCE_STOCK);
    }

    /**
     * @inheritDoc
     */
    public function getSeller()
    {
        return $this->getData(self::SELLER);
    }

    /**
     * @inheritDoc
     */
    public function getCoefficient()
    {
        return $this->getData(self::COEFFICIENT);
    }

    /**
     * @inheritDoc
     */
    public function getRateCode()
    {
        return $this->getData(self::RATE_CODE);
    }

    /**
     * @inheritDoc
     */
    public function getStockAlgorithm()
    {
        return $this->getData(self::STOCK_ALGORITHM);
    }

    /**
     * @inheritDoc
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * @inheritDoc
     */
    public function setId($ruleId)
    {
        return $this->setData(self::RULE_ID, $ruleId);
    }

    /**
     * @inheritDoc
     */
    public function setWebsiteId($websiteId)
    {
        return $this->setData(self::WEBSITE_ID, $websiteId);
    }

    /**
     * @inheritDoc
     */
    public function setStoreId($storeId)
    {
        return $this->setData(self::STORE_ID, $storeId);
    }

    /**
     * @inheritDoc
     */
    public function setChain($chain)
    {
        return $this->setData(self::CHAIN, $chain);
    }

    /**
     * @inheritDoc
     */
    public function setFastmagShop($fastmagShop)
    {
        return $this->setData(self::FASTMAG_SHOP, $fastmagShop);
    }

    /**
     * @inheritDoc
     */
    public function setReferenceStock($referenceStock)
    {
        return $this->setData(self::REFERENCE_STOCK, $referenceStock);
    }

    /**
     * @inheritDoc
     */
    public function setSeller($seller)
    {
        return $this->setData(self::SELLER, $seller);
    }

    /**
     * @inheritDoc
     */
    public function setCoefficient($coefficient)
    {
        return $this->setData(self::COEFFICIENT, $coefficient);
    }

    /**
     * @inheritDoc
     */
    public function setRateCode($rateCode)
    {
        return $this->setData(self::RATE_CODE, $rateCode);
    }

    /**
     * @inheritDoc
     */
    public function setStockAlgorithm($stockAlgorithm)
    {
        return $this->setData(self::STOCK_ALGORITHM, $stockAlgorithm);
    }
}