<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-02-12
 ******************************************************************************/

namespace Fastmag\Sync\Process\Entity\ToMagento;

use Fastmag\Sync\Model\Config;

/**
 * Class Product
 *
 * Entity class for product.
 * Save and transform data from Fastmag for Magento easy integration,
 * and transfer it from hydration worker to integration worker
 *
 * @deprecated Data formating will be done on integration worker
 */
class Product
{
    /** @var string $parentRef */
    protected $parentRef;

    /** @var string $colorRef */
    protected $colorRef;

    /** @var int $magentoId */
    protected $magentoId;

    /** @var bool $isColor */
    protected $isColor;

    /** @var bool $visibleWeb */
    protected $visibleWeb;

    /** @var bool $active */
    protected $active;

    /** @var string $creationDate */
    protected $creationDate;

    /** @var int $stocLevel */
    protected $stockLevel;

    /** @var string $stocksList */
    protected $stocksList;

    /** @var float $width */
    protected $width;

    /** @var float $length */
    protected $length;

    /** @var float $depth */
    protected $depth;

    /** @var Config $scopeConfig */
    protected $config;

    /**
     * Product constructor.
     *
     * @param Config $config
     */
    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    /**
     * @inheritDoc
     */
    public function isColor()
    {
        if ($this->isColor === null) {
            $this->isColor = $this->colorRef !== '';
        }

        return $this->isColor;
    }

    /**
     * @inheritDoc
     */
    public function getFastmagRef()
    {
        $result = $this->parentRef;

        if ($this->isColor()) {
            $result = $this->colorRef;
        }

        return $result;
    }

    /**
     * @inheritDoc
     */
    public function setParentRef($parentRef)
    {
        $this->parentRef = $parentRef;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setColorRef($colorRef)
    {
        $this->colorRef = $colorRef;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setMagentoId($magentoId)
    {
        $this->magentoId = $magentoId;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setVisibleWeb($visibleWeb)
    {
        $this->visibleWeb = $visibleWeb;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setCreationDate($creationDate)
    {
        $this->creationDate = $creationDate;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setStockLevel($stockLevel)
    {
        $this->stockLevel = $stockLevel;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setStocksList($stocksList)
    {
        $this->stocksList = $stocksList;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setWidth($width)
    {
        $this->width = $width;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setLength($length)
    {
        $this->length = $length;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setDepth($depth)
    {
        $this->depth = $depth;

        return $this;
    }
}
