<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-02-12
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker;

use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Process\Worker;
use Magento\Framework\App\ResourceConnection;

/**
 * Class Hydration
 *
 * Abstract class inherited by all hydration workers (to Fastmag and to Magento)
 */
abstract class Hydration extends Worker
{
    /** @var Config $config */
    protected $config;

    /**
     * Hydration constructor.
     *
     * @param Logger             $logger
     * @param ResourceConnection $resourceConnection
     * @param Config             $config
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        Config $config
    ) {
        parent::__construct($logger, $resourceConnection);

        $this->config = $config;
    }

    /**
     * Get config limit for hydration
     *
     * @return string
     */
    protected function getLimit()
    {
        return $this->config->getValue(Config::XML_PATH_JOBQUEUE_ADVANCED_HYDRATION_SIZE);
    }
}
