<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-05-17
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker;

use Fastmag\Sync\Exception\ProcessException;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Jobqueue as Job;
use Fastmag\Sync\Process\Worker;
use Magento\Framework\App\ResourceConnection;

/**
 * Class Integration
 *
 * Abstract class inherited by all integration workers (to Fastmag and to Magento)
 */
abstract class Integration extends Worker
{
    /** @var Config $config */
    protected $config;

    /** @var array $errors */
    protected $errors = [];

    /** @var array $success */
    protected $success = [];

    /**
     * Customer constructor.
     *
     * @param Logger             $logger
     * @param ResourceConnection $resourceConnection
     * @param Config             $config
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        Config $config
    ) {
        parent::__construct($logger, $resourceConnection);

        $this->config = $config;
    }

    /**
     * @return array
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @return int
     */
    public function getErrorsCount()
    {
        return count($this->errors);
    }

    /**
     * @param Job $job
     *
     * @return bool
     */
    public function isJobInError($job)
    {
        $result = false;

        if ($job->getId() && $this->getErrorsCount() && array_key_exists($job->getId(), $this->getErrors())) {
            $result = true;
        }

        return $result;
    }

    /**
     * Returns the activation of the synchronization of the current entity
     *
     * @return bool
     */
    public function isEnabled()
    {
        return true;
    }

    /**
     * Check initial conditions to run the worker
     *
     * @throws ProcessException
     */
    protected function initiate()
    {
        if (!$this->isEnabled()) {
            throw new ProcessException('Worker "' . $this->code . '" was called, even though it is disabled');
        } elseif ($this->jobs->count() <= 0) {
            throw new ProcessException('Worker "' . $this->code . '" was called, but without jobs to integrate');
        }
    }
}
