<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-05-31
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToFastmag;

use Fastmag\Sync\Api\Jobqueue\ToFastmagRepositoryInterface as JobRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\ResourceModel\Jobqueue\ToFastmag\Collection;
use Fastmag\Sync\Model\System\Connection\Api;
use Fastmag\Sync\Process\Worker\Integration as AbstractIntegration;
use Magento\Framework\App\ResourceConnection;

/**
 * Class Integration
 *
 * Abstract class inherited by all ToFastmag integration workers
 *
 * @property Collection $jobs
 */
abstract class Integration extends AbstractIntegration
{
    public const DEFAULT_REFERER = 'magento';

    /** @var JobRepository $jobRepository */
    protected $jobRepository;

    /** @var Api $api */
    protected $api;

    /**
     * Integration constructor.
     *
     * @param Logger             $logger
     * @param ResourceConnection $resourceConnection
     * @param Config             $config
     * @param JobRepository      $jobRepository
     * @param Api                $api
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        Config $config,
        JobRepository $jobRepository,
        Api $api
    ) {
        parent::__construct($logger, $resourceConnection, $config);

        $this->jobRepository = $jobRepository;
        $this->api = $api;
    }
}
