<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-06-04
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToFastmag\Integration;

use Fastmag\Sync\Api\Data\OrderInterfaceFactory as SyncOrderFactory;
use Fastmag\Sync\Api\Jobqueue\ToFastmagRepositoryInterface as JobRepository;
use Fastmag\Sync\Api\OrderRepositoryInterface as SyncOrderRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\System\Connection\Api;
use Fastmag\Sync\Process\Worker\ToFastmag\Integration;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\App\ResourceConnection;

/**
 * Class Order
 *
 * Abstract class for Order related Integration workers
 */
abstract class Order extends Integration
{
    /** @var SyncOrderFactory $syncOrderFactory */
    protected $syncOrderFactory;

    /** @var SyncOrderRepository $syncOrderRepository */
    protected $syncOrderRepository;

    /** @var SearchCriteriaBuilder $searchCriteriaBuilder */
    protected $searchCriteriaBuilder;

    /**
     * Integration constructor.
     *
     * @param Logger                $logger
     * @param ResourceConnection    $resourceConnection
     * @param Config                $config
     * @param JobRepository         $jobRepository
     * @param Api                   $api
     * @param SyncOrderFactory      $syncedOrderFactory
     * @param SyncOrderRepository   $syncedOrderRepository
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        Config $config,
        JobRepository $jobRepository,
        Api $api,
        SyncOrderFactory $syncedOrderFactory,
        SyncOrderRepository $syncedOrderRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder
    ) {
        parent::__construct($logger, $resourceConnection, $config, $jobRepository, $api);

        $this->syncOrderFactory = $syncedOrderFactory;
        $this->syncOrderRepository = $syncedOrderRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }
}
