<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-09-15
 ******************************************************************************/

namespace Fastmag\Sync\Setup\Patch\Data;

use Fastmag\Sync\Model\Constants;
use Magento\Customer\Api\AddressMetadataInterface;
use Magento\Customer\Setup\CustomerSetupFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchRevertableInterface;
use Zend_Validate_Exception;

/**
 * Class InstallCustomerAddressAttributes
 *
 * Installer for customer address attributes
 */
class InstallCustomerAddressAttributes implements DataPatchInterface, PatchRevertableInterface
{
    /** @var ModuleDataSetupInterface */
    private $moduleDataSetup;

    /** @var CustomerSetupFactory $customerSetupFactory */
    private $customerSetupFactory;

    /**
     * InstallData constructor
     *
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param CustomerSetupFactory     $customerSetupFactory
     */
    public function __construct(ModuleDataSetupInterface $moduleDataSetup, CustomerSetupFactory $customerSetupFactory)
    {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->customerSetupFactory = $customerSetupFactory;
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @inheritDoc
     *
     * @throws LocalizedException
     * @throws Zend_Validate_Exception
     */
    public function apply()
    {
        $customerSetup = $this->customerSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $customerSetup->addAttribute(
            AddressMetadataInterface::ENTITY_TYPE_ADDRESS,
            Constants::ATTRIBUTE_ADDRESS_ALIAS_CODE,
            [
                'label'    => 'Fastmag alias',
                'required' => false,
                'position' => 100,
                'system'   => false,
                'default'  => Constants::ATTRIBUTE_ADDRESS_ALIAS_DEFAULT
            ]
        );
    }

    /**
     * @inheritDoc
     */
    public function revert()
    {
        $customerSetup = $this->customerSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $customerSetup->removeAttribute(
            AddressMetadataInterface::ENTITY_TYPE_ADDRESS,
            Constants::ATTRIBUTE_ADDRESS_ALIAS_CODE
        );
    }
}
