<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-24
 ******************************************************************************/

namespace Fastmag\Sync\Ui\Component\Listing\Column\Rule\Storeseller;

use Fastmag\Sync\Exception\NoConnectionException;
use Fastmag\Sync\Model\System\Connection\Edi\Config as EdiConfig;
use Fastmag\Sync\Model\System\Connection\Edi\Test as EdiTest;
use Magento\Framework\View\Asset\Repository;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class Edi
 *
 * Column renderer for rules EDI status
 */
class Edi extends Column
{
    /** @var Repository $assetRepo */
    protected $assetRepo;

    /** @var EdiConfig $ediConfig */
    private $ediConfig;

    /** @var EdiTest $ediTest */
    private $ediTest;

    /**
     * Edi constructor
     *
     * @param ContextInterface   $context
     * @param UiComponentFactory $uiComponentFactory
     * @param Repository         $assetRepo
     * @param EdiConfig          $ediConfig
     * @param EdiTest            $ediTest
     * @param array              $components
     * @param array              $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        Repository $assetRepo,
        EdiConfig $ediConfig,
        EdiTest $ediTest,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);

        $this->assetRepo = $assetRepo;
        $this->ediConfig = $ediConfig;
        $this->ediTest = $ediTest;
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     *
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $item[$this->getData('name')] = $this->prepareItem($item);
            }
        }

        return $dataSource;
    }

    /**
     * Get data
     *
     * @param array $item
     *
     * @return string
     */
    protected function prepareItem(array $item)
    {
        $response = false;
        $errorMessage = '';

        $config = [
            'host'     => $this->ediConfig->getHost(),
            'port'     => $this->ediConfig->getPort(),
            'chain'    => $item['chain'],
            'shop'     => $item['fastmag_shop'],
            'user'     => $this->ediConfig->getUser(),
            'password' => $this->ediConfig->getPassword(),
            'ssl'      => $this->ediConfig->getSsl(),
        ];

        try {
            $response = $this->ediTest->execute($config);
        } catch (NoConnectionException $e) {
            $errorMessage = $e->getMessage();
        }

        if ($response !== true) {
            $content = '<img src="' . $this->assetRepo->getUrl('Fastmag_Sync::images/nok.gif') . '"
                alt="' . __('EDI connection - Error') . '"
                title="' . __('EDI connection - Error: %1', strip_tags($errorMessage)) . '" />';
        } else {
            $content = '<img src="' . $this->assetRepo->getUrl('Fastmag_Sync::images/ok.gif') . '"
                alt="' . __('EDI connection - OK') . '"
                title="' . __('EDI connection - OK') . '" />';
        }

        return $content;
    }
}
