<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-02-12
 ******************************************************************************/

namespace Fastmag\Sync\Block\Adminhtml\Jobqueue\Tomagento\Listing\Button;

use Fastmag\Sync\Model\Config;
use Magento\Backend\Block\Widget\Context;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

/**
 * Class ResetPrices
 *
 * Config class for "Reset prices" button
 */
class ResetPrices implements ButtonProviderInterface
{
    /** @var Context $context */
    protected $context;

    /** @var Config $config */
    protected $config;

    /**
     * ResetPrices constructor
     *
     * @param Context $context
     * @param Config  $config
     */
    public function __construct(Context $context, Config $config)
    {
        $this->context = $context;
        $this->config = $config;
    }

    /**
     * @inheritDoc
     */
    public function getButtonData()
    {
        return [
            'label'      => __('Reset prices'),
            'class'      => 'primary',
            'sort_order' => 10,
            'on_click'   => $this->getOnClickFunction()
        ];
    }

    /**
     * Generate URL by route and parameters
     *
     * @param string $route
     * @param array  $params
     *
     * @return string
     */
    public function getUrl($route = '', $params = [])
    {
        return $this->context->getUrlBuilder()->getUrl($route, $params);
    }

    /**
     * Get on_click JS function depending the product sync config
     *
     * @return string
     */
    protected function getOnClickFunction()
    {
        $result = sprintf("location.href = '%s';", $this->getUrl('*/*/resetPrices'));

        if ($this->config->isSetFlag(Config::XML_PATH_PRODUCT_IMPORT_ONLY_INVENTORY)) {
            $result = 'deleteConfirm(\''
                . __('The config indicates that only inventory levels must be synced. Are you sure you want to reset prices?')
                . '\', \'' . $this->getUrl('*/*/resetPrices') . '\')';
        }

        return $result;
    }
}
