<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Block\Adminhtml\Rule\Paymentcode\Edit\Button;

use Fastmag\Sync\Api\Rule\PaymentcodeRepositoryInterface;
use Magento\Backend\Block\Widget\Context;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Class Generic
 *
 * Generic button class for Paymentcode rules admin pages
 *
 * @todo change architecture to avoid code duplication
 */
class Generic
{
    /** @var Context $context */
    protected $context;

    /** @var PaymentcodeRepositoryInterface $paymentcodeRepository */
    protected $paymentcodeRepository;

    /**
     * Generic constructor
     *
     * @param Context                        $context
     * @param PaymentcodeRepositoryInterface $paymentcodeRepository
     */
    public function __construct(
        Context $context,
        PaymentcodeRepositoryInterface $paymentcodeRepository
    ) {
        $this->context = $context;
        $this->paymentcodeRepository = $paymentcodeRepository;
    }

    /**
     * Return rule ID
     *
     * @return int|null
     *
     * @throws LocalizedException
     */
    public function getRuleId()
    {
        try {
            return $this->paymentcodeRepository->getById(
                $this->context->getRequest()->getParam('id')
            )->getId();
        } catch (NoSuchEntityException $e) {
            // No entity
        }

        return null;
    }

    /**
     * Generate URL by route and parameters
     *
     * @param string $route
     * @param array  $params
     *
     * @return string
     */
    public function getUrl($route = '', $params = [])
    {
        return $this->context->getUrlBuilder()->getUrl($route, $params);
    }
}
