<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Rule\Storeseller;

use Fastmag\Sync\Api\Rule\StoresellerRepositoryInterface;
use Fastmag\Sync\Controller\Adminhtml\Rule\Storeseller as ControllerAbstract;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\ForwardFactory;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\Controller\ResultInterface;

/**
 * Class NewAction
 *
 * Storeseller new action
 */
class NewAction extends ControllerAbstract implements HttpGetActionInterface
{
    /** @var ForwardFactory $resultForwardFactory */
    protected $resultForwardFactory;

    /**
     * NewAction constructor
     *
     * @param Context                        $context
     * @param DataPersistorInterface         $dataPersistor
     * @param StoresellerRepositoryInterface $ruleRepository
     * @param ForwardFactory                 $resultForwardFactory
     */
    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor,
        StoresellerRepositoryInterface $ruleRepository,
        ForwardFactory $resultForwardFactory
    ) {
        parent::__construct($context, $dataPersistor, $ruleRepository);

        $this->resultForwardFactory = $resultForwardFactory;
    }

    /**
     * Create new rule
     *
     * @return ResultInterface
     */
    public function execute()
    {
        $resultForward = $this->resultForwardFactory->create();

        return $resultForward->forward('edit');
    }
}
